PGraphics drawing = createGraphics(640, 480, P2D);
int ang = 0;
PVector pos = new PVector(0, 0);
int stepsize = 10;
float[][] marks = new float[0][0];


void setup() {
  size(640, 480, P2D);
  background(0);
  stroke(255);
  strokeWeight(1);
  noFill();
  drawing.beginDraw();
  drawing.stroke(255);
  drawing.strokeWeight(1);
  drawing.endDraw();
}

void draw() {

  background(0);


  pushMatrix();

  translate(320,240);
  //rotate(-radians(ang));
  float zoo = map(mouseX, 0, width, 0.1, 4.5);
  scale(zoo);
  for (float[] m : marks) {
    stroke(random(100,255));
    line(m[0]+random(2), m[1]+random(2), m[2]+random(2), m[3]+random(2));
  }

  popMatrix();

  pushMatrix();
  translate(320, 240);
  translate(pos.x, pos.y);
  rotate(-radians(ang));
  float zoom = map(mouseX, 0, width, 0.1, 4.5);
  scale(zoom);
  stroke(255);
  ellipse(0, 0, 20, 10);
  stroke(255, 0, 0);
  //ellipse(10, 0, 20, 20);

  popMatrix();
  renderPreview();
  //stepTurtle();
}

void keyPressed() {

  switch(keyCode) {
  case ALT:
    stepTurtle();
    break;

  case UP:
    stepsize += 10;
    if (stepsize >= 100) stepsize = 100;
    break;

  case DOWN:
    stepsize -= 10;
    if (stepsize <= 10) stepsize = 10;
    break;

  case RIGHT:
    ang -= 30;
    if (ang <= -360) ang = 0;
    break;

  case LEFT:
    ang += 30;
    if (ang >= 360) ang = 0;
    break;
  }
}

void stepTurtle() {
  PVector newPos = new PVector(pos.x, pos.y);
  newPos.x = pos.x + (stepsize * cos(radians(ang)));
  newPos.y = pos.y - (stepsize * sin(radians(ang))); 
  drawing.beginDraw();
  drawing.line(pos.x, pos.y, newPos.x, newPos.y);
  float[] newMark = {
    pos.x, pos.y, newPos.x, newPos.y
  };
  marks = (float[][]) append(marks, newMark);
  drawing.endDraw();
  pos.x = newPos.x;
  pos.y = newPos.y;
}

void renderPreview() {
  stroke(255, 255, 0);
  line(pos.x, pos.y, pos.x +(stepsize * cos(radians(ang))), pos.y - (stepsize * sin(radians(ang))));
}

//(new-x (+ turtle-x (* length (cos turtle-theta))))
//(new-y (- turtle-y (* length (sin turtle-theta))))

